package ru.yandex.qe.dispenser.ws;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

import org.jetbrains.annotations.Nullable;
import ru.yandex.qe.dispenser.domain.bot.BigOrder;
import ru.yandex.qe.dispenser.ws.bot.BigOrderManager;

public final class BigOrderUtils {
    private BigOrderUtils() {}

    public static Map<Long, BigOrder> validateBigOrders(final BigOrderManager bigOrderManager, @Nullable final Set<Long> bigOrderIds) {
        if (bigOrderIds == null || bigOrderIds.isEmpty()) {
            return new HashMap<>();
        }
        final Set<BigOrder> bigOrders = bigOrderManager.getByIds(bigOrderIds);
        if (bigOrders.size() != bigOrderIds.size()) {
            final Set<Long> existingBigOrderIds = bigOrders.stream().map(BigOrder::getId).collect(Collectors.toSet());
            final Set<Long> missingBigOrderIds = new HashSet<>(bigOrderIds);
            missingBigOrderIds.removeAll(existingBigOrderIds);
            final String missingIdsString = missingBigOrderIds.stream().map(Object::toString).collect(Collectors.joining(", "));
            throw new IllegalArgumentException("Big orders with ids [" + missingIdsString + "] are missing.");
        }
        return bigOrders.stream().collect(Collectors.toMap(BigOrder::getId, Function.identity()));
    }
}
