package ru.yandex.qe.dispenser.ws;

import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

import io.swagger.annotations.Api;
import io.swagger.annotations.Authorization;
import org.springframework.stereotype.Service;

import ru.yandex.qe.dispenser.api.v1.DiBotSyncStatus;
import ru.yandex.qe.dispenser.domain.bot.BotSyncStatus;
import ru.yandex.qe.dispenser.domain.dao.bot.monitoring.BotSyncStatusDao;
import ru.yandex.qe.dispenser.swagger.DispenserSecurityDefinition;
import ru.yandex.qe.dispenser.swagger.SwaggerTags;

@Path("/v1/bot-sync-status")
@Produces(ServiceBase.APPLICATION_JSON_UTF_8)
@Service("bot-sync-status")
@Api(tags = {SwaggerTags.DISPENSER_API}, authorizations = {@Authorization(value = DispenserSecurityDefinition.AUTHORIZATION_SCHEME_NAME)})
public class BotSyncStatusService {

    private final static DiBotSyncStatus EMPTY_DI_BOT_STATUS = DiBotSyncStatus.builder().build();

    private final BotSyncStatusDao botSyncStatusDao;

    @Inject
    public BotSyncStatusService(final BotSyncStatusDao botSyncStatusDao) {
        this.botSyncStatusDao = botSyncStatusDao;
    }

    /**
     * Get last {@code BotSyncStatus}.
     * @return {@code BotSyncStatus}
     */
    @GET
    @Access
    public DiBotSyncStatus get() {
        final BotSyncStatus botSyncStatus = botSyncStatusDao.read();

        return botSyncStatus != null
                ? botSyncStatus.toView()
                : EMPTY_DI_BOT_STATUS;
    }
}
