package ru.yandex.qe.dispenser.ws;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import io.swagger.annotations.Api;
import io.swagger.annotations.Authorization;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;

import ru.yandex.qe.dispenser.api.v1.DiDispenserSettings;
import ru.yandex.qe.dispenser.domain.DispenserSettings;
import ru.yandex.qe.dispenser.domain.dao.dispenser_admins.DispenserAdminsDao;
import ru.yandex.qe.dispenser.domain.dao.person.PersonDao;
import ru.yandex.qe.dispenser.swagger.DispenserSecurityDefinition;
import ru.yandex.qe.dispenser.swagger.SwaggerTags;
import ru.yandex.qe.dispenser.ws.reqbody.DispenserSettingsBody;

@Path("/v1/settings")
@Produces(ServiceBase.APPLICATION_JSON_UTF_8)
@org.springframework.stereotype.Service("dispenser")
@Api(tags = {SwaggerTags.DISPENSER_API}, authorizations = {@Authorization(value = DispenserSecurityDefinition.AUTHORIZATION_SCHEME_NAME)})
public class DispenserSettingsService extends ServiceBase {

    @Autowired
    private PersonDao personDao;

    @Autowired
    private DispenserAdminsDao dispenserAdminsDao;

    @GET
    public DiDispenserSettings getDispenser() {
        return DispenserSettings.build().build().toView();
    }

    @PATCH
    @Access(dispenserAdmin = true)
    @Consumes(MediaType.APPLICATION_JSON)
    public DiDispenserSettings updateDispenserSettings(@RequestBody @NotNull final DispenserSettingsBody body) {
        if (body.getAdmins() != null) {
            dispenserAdminsDao.setDispenserAdmins(personDao.readPersonsByLogins(
                    body.getAdmins()));
        }

        return DispenserSettings.build().build().toView(dispenserAdminsDao);
    }
}
