package ru.yandex.qe.dispenser.ws;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

import io.swagger.annotations.Api;
import io.swagger.annotations.Authorization;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Service;
import ru.yandex.qe.dispenser.swagger.DispenserSecurityDefinition;
import ru.yandex.qe.dispenser.swagger.SwaggerTags;

@Path("/eventMonitoring")
@Controller
@Produces(ServiceBase.TEXT_PLAIN_UTF_8)
@Service("eventMonitoring")
@Api(tags = {SwaggerTags.DISPENSER_API}, authorizations = {@Authorization(value = DispenserSecurityDefinition.AUTHORIZATION_SCHEME_NAME)})
public class EventMonitoringService {

    private static final int CRIT_CODE = 453;
    private static final int WARN_CODE = 452;

    @GET
    @Path("/preOrderJob")
    public Response getPreOrderJobStatus() {
        return Response.ok("OK\n").build();
    }

}
