package ru.yandex.qe.dispenser.ws;

import java.util.List;
import java.util.Set;

import javax.inject.Inject;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;
import ru.yandex.qe.dispenser.api.v1.field.DiField;
import ru.yandex.qe.dispenser.api.v1.field.DiProjectFields;
import ru.yandex.qe.dispenser.domain.Campaign;
import ru.yandex.qe.dispenser.domain.MultiProjectFieldsContext;
import ru.yandex.qe.dispenser.domain.ProjectFieldsContext;
import ru.yandex.qe.dispenser.domain.SingleProjectFieldsContext;
import ru.yandex.qe.dispenser.domain.dao.campaign.CampaignDao;
import ru.yandex.qe.dispenser.ws.param.ProjectFieldsParam;

@Component
public class ProjectFieldsContextFactory {

    @NotNull
    private final CampaignDao campaignDao;

    @Inject
    public ProjectFieldsContextFactory(@NotNull final CampaignDao campaignDao) {
        this.campaignDao = campaignDao;
    }

    public ProjectFieldsContext single(@NotNull final ProjectFieldsParam fields) {
        final boolean arePermissionsRequested = arePermissionsRequested(fields);
        return new SingleProjectFieldsContext(getActiveCampaignsIfRequired(arePermissionsRequested));
    }

    public ProjectFieldsContext multi(@NotNull final ProjectFieldsParam fields) {
        final boolean arePermissionsRequested = arePermissionsRequested(fields);
        return new MultiProjectFieldsContext(getActiveCampaignsIfRequired(arePermissionsRequested));
    }

    @Nullable
    private List<Campaign> getActiveCampaignsIfRequired(final boolean arePermissionsRequested) {
        if (!arePermissionsRequested) {
            return null;
        }
        return campaignDao.getAllActiveSorted();
    }

    private boolean arePermissionsRequested(@NotNull final ProjectFieldsParam fields) {
        if (fields.isEmpty()) {
            return false;
        }
        final Set<DiField<?>> diFields = fields.get();
        return diFields.stream().anyMatch(f -> f.getKey().equals(DiProjectFields.PERMISSIONS.getKey()));
    }

}
