package ru.yandex.qe.dispenser.ws;

import ru.yandex.qe.dispenser.domain.QuotaChangeRequest;

import javax.annotation.Nullable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class QuotaRequestChangeValues {
    private final Map<Long, Long> allocatedByChangeId = new HashMap<>();
    private final Map<Long, Long> readyByChangeId = new HashMap<>();
    private final Map<Long, Long> allocatingByChangeId = new HashMap<>();
    private final Set<Long> requestIdsToResetReadyAllocationState = new HashSet<>();
    private final Set<Long> requestIdsWithUpdate = new HashSet<>();
    private final Set<QuotaChangeRequest> affectedInReadyAmountUpdateRequests = new HashSet<>();
    private final Set<QuotaChangeRequest> affectedInAllocatedAmountUpdateRequests = new HashSet<>();
    private final Set<QuotaChangeRequest> affectedInAllocatingAmountUpdateRequests = new HashSet<>();
    private final Map<Long, String> commentByRequestId = new HashMap<>();

    public void setAllocated(final QuotaChangeRequest request, final QuotaChangeRequest.Change change, final long allocated) {
        allocatedByChangeId.put(change.getId(), allocated);
        affectedInAllocatedAmountUpdateRequests.add(request);
        if (change.getResource().getService().getSettings().isManualQuotaAllocation()) {
            requestIdsToResetReadyAllocationState.add(request.getId());
        }
        requestIdsWithUpdate.add(request.getId());
    }

    public void setReady(final QuotaChangeRequest request, final long changeId, final long ready) {
        readyByChangeId.put(changeId, ready);
        affectedInReadyAmountUpdateRequests.add(request);
        requestIdsWithUpdate.add(request.getId());
    }

    public void setAllocating(final QuotaChangeRequest request, final long changeId, final long allocating) {
        allocatingByChangeId.put(changeId, allocating);
        affectedInAllocatingAmountUpdateRequests.add(request);
        requestIdsWithUpdate.add(request.getId());
    }

    public void setRequestComment(final QuotaChangeRequest request, @Nullable final String comment) {
        commentByRequestId.put(request.getId(), comment);
    }

    public Map<Long, Long> getAllocatedByChangeId() {
        return allocatedByChangeId;
    }

    public Map<Long, Long> getReadyByChangeId() {
        return readyByChangeId;
    }

    public Map<Long, Long> getAllocatingByChangeId() {
        return allocatingByChangeId;
    }

    public Set<Long> getRequestIdsToResetReadyAllocationState() {
        return requestIdsToResetReadyAllocationState;
    }

    public Set<Long> getRequestIdsWithUpdate() {
        return requestIdsWithUpdate;
    }

    public Set<QuotaChangeRequest> getAffectedInReadyAmountUpdateRequests() {
        return affectedInReadyAmountUpdateRequests;
    }

    public Set<QuotaChangeRequest> getAffectedInAllocatedAmountUpdateRequests() {
        return affectedInAllocatedAmountUpdateRequests;
    }

    public Set<QuotaChangeRequest> getAffectedInAllocatingAmountUpdateRequests() {
        return affectedInAllocatingAmountUpdateRequests;
    }

    public Map<Long, String> getCommentByRequestId() {
        return commentByRequestId;
    }
}
