package ru.yandex.qe.dispenser.ws;

import java.io.OutputStream;
import java.util.Collection;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.StreamingOutput;

import io.swagger.annotations.Api;
import io.swagger.annotations.Authorization;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

import ru.yandex.qe.dispenser.domain.QuotaView;
import ru.yandex.qe.dispenser.domain.aspect.HierarchyRequired;
import ru.yandex.qe.dispenser.domain.aspect.SecondaryOperation;
import ru.yandex.qe.dispenser.domain.hierarchy.Hierarchy;
import ru.yandex.qe.dispenser.swagger.DispenserSecurityDefinition;
import ru.yandex.qe.dispenser.swagger.SwaggerTags;
import ru.yandex.monlib.metrics.encode.spack.format.CompressionAlg;
import ru.yandex.monlib.metrics.encode.spack.format.TimePrecision;

/**
 * General statistic by projects
 */
@Service("solomon")
@Path("/solomon")
@Produces(ServiceBase.APPLICATION_JSON_UTF_8)
@Api(tags = {SwaggerTags.DISPENSER_API}, authorizations = {@Authorization(value = DispenserSecurityDefinition.AUTHORIZATION_SCHEME_NAME)})
public class SolomonService extends ServiceBase {

    @GET
    @NotNull
    @SecondaryOperation
    @HierarchyRequired(canReject = true)
    @Path(QuotaReadUpdateService.PATH)
    @Produces("application/x-solomon-spack")
    public StreamingOutput quotas() {
        final Collection<QuotaView> quotas = Hierarchy.get().getQuotaCache().getAll();
        return new StreamingOutput() {
            @Override
            public void write(final OutputStream output) {
                QuotaSpackEncoder.encode(TimePrecision.SECONDS, CompressionAlg.LZ4, output, quotas);
            }
        };
    }

}
