package ru.yandex.qe.dispenser.ws;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;

import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

import ru.yandex.qe.dispenser.InstrumentedQloudTvmService;

public class TvmDestination {

    private final long destinationId;
    private final InstrumentedQloudTvmService tvmService;

    @Inject
    public TvmDestination(final long destinationId, final InstrumentedQloudTvmService tvmService) {
        this.destinationId = destinationId;
        this.tvmService = tvmService;
    }

    public void runAuthorized(final Runnable r) {
        runAuthorized(Executors.callable(r, null));
    }

    public <V> V runAuthorized(final Callable<V> callable) {
        final String serviceTicket = tvmService.getTicket(String.valueOf(destinationId));
        final TvmIdentity requestIdentity = new TvmIdentity(serviceTicket);
        try {
            return requestIdentity.callWith(callable);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <V> V runAuthorizedProxy(final Callable<V> callable) {
        final String serviceTicket = tvmService.getTicket(String.valueOf(destinationId));
        final TvmIdentity requestIdentity = new TvmIdentity(serviceTicket);
        try {
            return requestIdentity.callWith(callable);
        } catch (WebApplicationException e) {
            Response response = fromResponseWithoutEntity(e.getResponse())
                    .entity(e.getMessage())
                    .build();
            throw new WebApplicationException(response);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Response.ResponseBuilder fromResponseWithoutEntity(Response response) {
        Response.ResponseBuilder b = Response.status(response.getStatus());
        for (String headerName : response.getHeaders().keySet()) {
            List<Object> headerValues = response.getHeaders().get(headerName);
            for (Object headerValue : headerValues) {
                b.header(headerName, headerValue);
            }
        }
        return b;
    }
}
