package ru.yandex.qe.dispenser.ws.abc;


import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

import javax.annotation.Nonnull;

import ru.yandex.qe.dispenser.api.v1.response.DiCursorPage;
import ru.yandex.qe.dispenser.domain.abc.ObjectWithId;

/**
 * Created by : farruxkarimov
 * Date: 11.10.2019
 */
public class AbcCursorItemIterator<T extends ObjectWithId, B extends CursorRequestBuilder<T, B>> implements Iterator<T> {
    private final B requestBuilder;

    private Iterator<T> currentIterator;
    private boolean isLastItemPack;
    private Integer lastItemId = null;
    private String cursor = null;

    AbcCursorItemIterator(final B requestBuilder) {
        this.requestBuilder = requestBuilder;
    }

    private void loadNextItems() {
        final DiCursorPage<T> items = requestBuilder
                .filterByCursorToId(cursor, lastItemId)
                .perform();

        currentIterator = items.iterator();
        isLastItemPack = !items.hasNext();
        cursor = items.cursor();
    }

    @Nonnull
    private Iterator<T> getCurrentIterator() {
        if (currentIterator == null) {
            loadNextItems();
        }

        return Objects.requireNonNull(currentIterator);
    }

    @Override
    public boolean hasNext() {
        final Iterator<T> iterator = getCurrentIterator();

        if (!iterator.hasNext()) {

            if (isLastItemPack) {
                return false;
            }

            loadNextItems();

            return getCurrentIterator().hasNext();
        } else {
            return true;
        }
    }

    @Override
    public T next() {
        if (hasNext()) {
            final T item = getCurrentIterator().next();
            lastItemId = item.getId();
            return item;
        }
        throw new NoSuchElementException("No elements");
    }

    public Stream<T> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this, 0), false);
    }
}
