package ru.yandex.qe.dispenser.ws.abc;

import java.time.Clock;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;

import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

import ru.yandex.qe.dispenser.domain.dao.project.ProjectDao;
import ru.yandex.qe.dispenser.domain.dao.project.ProjectManager;
import ru.yandex.qe.dispenser.domain.hierarchy.HierarchySupplier;
import ru.yandex.qe.dispenser.solomon.SolomonHolder;

@Configuration
@ParametersAreNonnullByDefault
@Profile("abc-sync")
public class AbcSyncConfiguration {

    @NotNull
    private final ProjectTreeSync projectTreeSync;
    @NotNull
    private final SolomonHolder solomonHolder;
    @NotNull
    private final HierarchySupplier hierarchySupplier;

    @Inject
    public AbcSyncConfiguration(final AbcApiHelper abcApiHelper,
                                final ProjectDao projectDao,
                                final UpdateProjectMembers updateProjectMembers,
                                final ProjectManager projectManager,
                                final SolomonHolder solomonHolder,
                                final HierarchySupplier hierarchySupplier) {
        this.hierarchySupplier = hierarchySupplier;
        this.projectTreeSync = new ProjectTreeSync(abcApiHelper, projectDao, updateProjectMembers, projectManager);
        this.solomonHolder = solomonHolder;
    }

    @Bean
    @Profile("secondary")
    public ProjectTreeSyncTask getProjectTreeSyncTask() {
        return new ProjectTreeSyncTask(projectTreeSync, Clock.systemDefaultZone(), solomonHolder, hierarchySupplier);
    }
}
