package ru.yandex.qe.dispenser.ws.abc;

import java.util.Collection;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import ru.yandex.qe.dispenser.domain.abc.AbcApi;
import ru.yandex.qe.dispenser.domain.abc.ObjectWithId;
import ru.yandex.qe.dispenser.ws.TvmDestination;

public abstract class BaseCursorServiceRelationRequestBuilder<T extends ObjectWithId, B extends BaseCursorServiceRelationRequestBuilder<T, B>>
        extends CursorRequestBuilder<T, B> implements BasePageServiceRelationRequestBuilder<T, B> {

    @Nullable
    protected String serviceIds;

    protected BaseCursorServiceRelationRequestBuilder(final AbcApi abcApi, final TvmDestination abcTvmDestination) {
        super(abcApi, abcTvmDestination);
    }

    @Override
    @Nonnull
    public B serviceId(final int serviceId) {
        this.serviceIds = String.valueOf(serviceId);
        return self();
    }

    @Override
    @Nonnull
    public B serviceId(final Collection<Integer> ids) {
        this.serviceIds = join(ids);
        return self();
    }
}
