package ru.yandex.qe.dispenser.ws.abc;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Stream;

import javax.annotation.Nonnull;

import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;

import ru.yandex.qe.dispenser.domain.abc.Page;

/**
 * Base request builder
 *
 * @param <T> abc entity returned by request
 * @param <B> request builder
 */
public interface BasePageRequestBuilder<T, B extends BasePageRequestBuilder<T, B>> {

    /**
     * Joiner for query param values. Reduce elements collection to {@link String} "element1, element2, element3"
     *
     * @param elements to join
     * @return {@link String} with joined values
     */
    default String join(final Collection<?> elements) {
        return StringUtils.join(elements, ",");
    }

    /**
     * Setter for query param "fields"
     *
     * @param fields names for query param "fields"
     * @return {@link B}
     */
    default B fields(@Nonnull final String... fields) {
        return fields(Sets.newHashSet(fields));
    }

    /**
     * Setter for query param "fields"
     *
     * @param fields set with values for query param "fields"
     * @return {@link B}
     */
    B fields(@Nonnull Set<String> fields);

    /**
     * Setter for query param "id__in"
     *
     * @param ids values for query param "id__in"
     * @return {@link B}
     */
    B ids(@Nonnull final Collection<Integer> ids);

    /**
     * Setter for query param "page_size"
     *
     * @param pageSize value for query param "page_size"
     * @return {@link B}
     */
    B pageSize(@Nonnull final Integer pageSize);

    /**
     * Performing request and return result page
     *
     * @return {@link Page<T>}
     */
    Page<T> perform();

    /**
     * Get {@link Stream} of {@link T} iterating {@link #perform()} returning {@link Page<T>} one by one
     *
     * @return {@link Stream} of {@link T}
     */
    Stream<T> stream();

    /**
     * Get {@link String} value for query param "field"
     *
     * @return {@link String} value for query param "field"
     */
    String getFields();
}
