package ru.yandex.qe.dispenser.ws.abc;


import java.util.Collection;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.qe.dispenser.domain.abc.AbcApi;
import ru.yandex.qe.dispenser.ws.TvmDestination;

@ParametersAreNonnullByDefault
public abstract class BaseServiceRelationRequestBuilder<T, B extends PageRequestBuilder<T, B>>
        extends PageRequestBuilder<T, B> implements BasePageServiceRelationRequestBuilder<T, B> {
    @Nullable
    protected String serviceIds;

    protected BaseServiceRelationRequestBuilder(final AbcApi abcApi, final TvmDestination abcTvmDestination) {
        super(abcApi, abcTvmDestination);
    }

    @Override
    @Nonnull
    public B serviceId(final int serviceId) {
        this.serviceIds = String.valueOf(serviceId);
        return self();
    }

    @Override
    @Nonnull
    public B serviceId(final Collection<Integer> ids) {
        this.serviceIds = join(ids);
        return self();
    }
}
