package ru.yandex.qe.dispenser.ws.abc;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import ru.yandex.qe.dispenser.domain.abc.AbcApi;
import ru.yandex.qe.dispenser.domain.abc.AbcServiceMember;
import ru.yandex.qe.dispenser.domain.abc.AbcServiceState;
import ru.yandex.qe.dispenser.domain.abc.Page;
import ru.yandex.qe.dispenser.ws.TvmDestination;

public class MembersByUsersRequestBuilder extends PageRequestBuilder<AbcServiceMember, MembersByUsersRequestBuilder> {

    @Nullable
    private String logins;
    @Nullable
    private String states;
    @Nullable
    private Long roleId;

    protected MembersByUsersRequestBuilder(final AbcApi abcApi, final TvmDestination abcTvmDestination) {
        super(abcApi, abcTvmDestination);
    }

    @Nonnull
    public MembersByUsersRequestBuilder logins(final Set<String> logins) {
        if (logins.isEmpty()) {
            this.logins = null;
        } else {
            this.logins = String.join(",", logins);
        }
        return this;
    }

    @Nonnull
    public MembersByUsersRequestBuilder states(final AbcServiceState... state) {
        if (state.length == 0) {
            this.states = null;
        } else {
            this.states = Arrays.stream(state)
                    .map(AbcServiceState::getKey)
                    .collect(Collectors.joining(","));
        }
        return this;
    }

    @Nonnull
    public MembersByUsersRequestBuilder role(final long roleId) {
        this.roleId = roleId;
        return this;
    }

    @Nonnull
    @Override
    protected Page<AbcServiceMember> execute() {
        return abcApi.getServiceMembersByUsers(logins, states, roleId, getFields(), page, pageSize);
    }

    @Nonnull
    @Override
    protected MembersByUsersRequestBuilder self() {
        return this;
    }

}
