package ru.yandex.qe.dispenser.ws.abc;

import java.util.Collection;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.qe.dispenser.domain.abc.AbcApi;
import ru.yandex.qe.dispenser.domain.abc.AbcServiceMember;
import ru.yandex.qe.dispenser.domain.abc.Page;
import ru.yandex.qe.dispenser.ws.TvmDestination;

@ParametersAreNonnullByDefault
public class MembersRequestBuilder extends BaseCursorServiceRelationRequestBuilder<AbcServiceMember, MembersRequestBuilder> {

    @Nullable
    private String roleId;
    @Nullable
    private String roleScopeId;

    protected MembersRequestBuilder(final AbcApi abcApi, final TvmDestination abcTvmDestination) {
        super(abcApi, abcTvmDestination);
    }

    @Nonnull
    public MembersRequestBuilder role(final int roleId) {
        this.roleId = String.valueOf(roleId);
        return this;
    }

    @Nonnull
    public MembersRequestBuilder role(final Collection<Integer> roleIds) {
        this.roleId = join(roleIds);
        return this;
    }

    @Nonnull
    public MembersRequestBuilder roleScope(final int roleScopeId) {
        this.roleScopeId = String.valueOf(roleScopeId);
        return this;
    }

    @Nonnull
    @Override
    protected Page<AbcServiceMember> execute() {
        return abcApi.getServiceMembers(smallestAcceptableServiceId, cursor, serviceIds, roleId, roleScopeId, getFields(), page, pageSize);
    }
}
