package ru.yandex.qe.dispenser.ws.abc;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.qe.dispenser.api.v1.response.DiPage;
import ru.yandex.qe.dispenser.client.v1.impl.AbstractPageItemIterator;

@ParametersAreNonnullByDefault
class PageIterator<T> extends AbstractPageItemIterator<T> {
    @Nonnull
    private final PageRequestBuilder<T, ?> pageRequestBuilder;


    PageIterator(final PageRequestBuilder<T, ?> pageRequestBuilder) {
        this.pageRequestBuilder = pageRequestBuilder;
    }

    @Override
    protected DiPage<T> loadPage(final int page) {
        return pageRequestBuilder
                .page(page)
                .perform();
    }
}
