package ru.yandex.qe.dispenser.ws.abc;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.qe.dispenser.domain.abc.AbcApi;
import ru.yandex.qe.dispenser.domain.abc.AbcRole;
import ru.yandex.qe.dispenser.domain.abc.Page;
import ru.yandex.qe.dispenser.ws.TvmDestination;

@ParametersAreNonnullByDefault
public class RoleRequestBuilder extends BaseServiceRelationRequestBuilder<AbcRole, RoleRequestBuilder> {

    protected RoleRequestBuilder(final AbcApi abcApi, final TvmDestination abcTvmDestination) {
        super(abcApi, abcTvmDestination);
    }

    @Nonnull
    @Override
    protected Page<AbcRole> execute() {
        return abcApi.getRoles(serviceIds, ids, getFields(), page, pageSize);
    }
}