package ru.yandex.qe.dispenser.ws.abc;

import java.util.Arrays;
import java.util.stream.Collectors;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.qe.dispenser.domain.abc.AbcApi;
import ru.yandex.qe.dispenser.domain.abc.AbcService;
import ru.yandex.qe.dispenser.domain.abc.AbcServiceState;
import ru.yandex.qe.dispenser.domain.abc.Page;
import ru.yandex.qe.dispenser.ws.TvmDestination;


@ParametersAreNonnullByDefault
public class ServiceRequestBuilder extends CursorRequestBuilder<AbcService, ServiceRequestBuilder> {

    @Nullable
    private Integer parentWithDescendants;
    @Nullable
    private String states;

    ServiceRequestBuilder(final AbcApi abcApi, final TvmDestination abcTvmDestination) {
        super(abcApi, abcTvmDestination);
    }

    @Nonnull
    public ServiceRequestBuilder parentWithDescendants(final int id) {
        this.parentWithDescendants = id;
        return this;
    }

    @Nonnull
    public ServiceRequestBuilder state(final AbcServiceState... state) {
        if (state.length == 0) {
            this.states = null;
        } else {
            this.states = Arrays.stream(state)
                    .map(AbcServiceState::getKey)
                    .collect(Collectors.joining(","));
        }
        return this;
    }

    @Override
    @Nonnull
    public Page<AbcService> execute() {
        return abcApi.getServices(ids, smallestAcceptableServiceId, cursor, getFields(), page, pageSize, parentWithDescendants, states);
    }
}
