package ru.yandex.qe.dispenser.ws.abc.validator;

import java.util.Map;
import java.util.Objects;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;

public class ProjectMembersValidationResult {

    private final Map<String, Map<String, Set<Long>>> missingRoles;
    private final Map<String, Map<String, Set<Long>>> excessRoles;

    @JsonCreator
    public ProjectMembersValidationResult(@NotNull @JsonProperty("missingRoles") final Map<String, Map<String, Set<Long>>> missingRoles,
                                          @NotNull @JsonProperty("excessRoles") final Map<String, Map<String, Set<Long>>> excessRoles) {
        this.missingRoles = missingRoles;
        this.excessRoles = excessRoles;
    }

    public Map<String, Map<String, Set<Long>>> getMissingRoles() {
        return missingRoles;
    }

    public Map<String, Map<String, Set<Long>>> getExcessRoles() {
        return excessRoles;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final ProjectMembersValidationResult that = (ProjectMembersValidationResult) o;
        return Objects.equals(missingRoles, that.missingRoles) &&
                Objects.equals(excessRoles, that.excessRoles);
    }

    @Override
    public int hashCode() {
        return Objects.hash(missingRoles, excessRoles);
    }

    @Override
    public String toString() {
        return "ProjectMembersValidationResult{" +
                "missingResponsibleRoles=" + missingRoles +
                ", excessResponsibleRoles=" + excessRoles +
                '}';
    }

}
