package ru.yandex.qe.dispenser.ws.abc.validator;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.springframework.stereotype.Component;

import ru.yandex.qe.dispenser.domain.hierarchy.Role;

@Component
public class ProjectMembersValidatorStub implements ProjectMembersValidator {

    @Override
    public ProjectMembersValidationResult validate() {

        final Map<String, Map<String, Set<Long>>> emptyResult = Stream.of(Role.MEMBER, Role.RESPONSIBLE)
                .collect(Collectors.toMap(Role::getKey, r -> Collections.emptyMap()));

        return new ProjectMembersValidationResult(emptyResult, emptyResult);
    }

}
