package ru.yandex.qe.dispenser.ws.admin;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.v1.DiAmount;
import ru.yandex.qe.dispenser.api.v1.DiPerformer;
import ru.yandex.qe.dispenser.api.v1.DiUnit;
import ru.yandex.qe.dispenser.api.v1.request.DiEntity;
import ru.yandex.qe.dispenser.api.v1.request.DiEntityReference;
import ru.yandex.qe.dispenser.api.v1.request.DiEntityUsage;
import ru.yandex.qe.dispenser.client.v1.DiOAuthToken;
import ru.yandex.qe.dispenser.client.v1.Dispenser;
import ru.yandex.qe.dispenser.client.v1.builder.BatchQuotaChangeRequestBuilder;
import ru.yandex.qe.dispenser.client.v1.impl.DispenserConfig;
import ru.yandex.qe.dispenser.client.v1.impl.RemoteDispenserFactory;

public class DiffUploader {
    private static final int RECIEVE_TIMEOUT = 100000;
    private static final int BATCH_SIZE = 1000;
    private static final AtomicLong DISK = new AtomicLong(0);
    private static final AtomicLong CHUNK = new AtomicLong(0);
    private static final AtomicLong NODE = new AtomicLong(0);

    private static final Map<String, Map<String, Long>> usages = new HashMap<>();
    private static final Set<String> createdIdSet = new HashSet<>();
    private static final String OLD_DUMP = "/Users/vkokarev/Downloads/data/production_dump_old.tsv";
    private static final String NEW_DUMP = "/Users/vkokarev/Downloads/data/production_dump.tsv";

    public static void main(String[] args) throws IOException, ParseException {
        final long start = System.currentTimeMillis();

        final Options options = new Options();
        options.addOption(new Option("h", "host", true, "target host"));
        options.addOption(new Option("t", "token", true, "zombie oauth token"));
        options.addOption(new Option("u", "url", true, "table url"));
        final CommandLineParser clp = new PosixParser();
        final CommandLine cl = clp.parse(options, args);

        final String host = cl.getOptionValue('h');
        final String oauthToken = cl.getOptionValue('t');
        final String url = cl.getOptionValue('u');

        final DispenserConfig config = new DispenserConfig();
        config.setDispenserHost(host);
        config.setServiceZombieOAuthToken(DiOAuthToken.of(oauthToken));
        config.setReceiveTimeout(RECIEVE_TIMEOUT);
        final Dispenser dispenser = new RemoteDispenserFactory(config).get();

        try (BufferedReader reader = new BufferedReader(new FileReader(OLD_DUMP))) {
            reader.lines().filter(s -> !s.isEmpty()).forEach(DiffUploader::parseOld);
        }

        final AtomicReference<BatchQuotaChangeRequestBuilder> ref = new AtomicReference<>(dispenser.quotas().changeInService("nirvana"));


        final AtomicInteger totalCounter = new AtomicInteger();
        final AtomicInteger counter = new AtomicInteger();

        try (BufferedReader reader = new BufferedReader(new FileReader(NEW_DUMP))) {
            reader.lines().filter(s -> !s.isEmpty()).forEach(line -> {
                final BatchQuotaChangeRequestBuilder builder = ref.get();

                boolean hasAny = parse(line, builder);
                counter.incrementAndGet();
                totalCounter.incrementAndGet();

                if (hasAny && counter.get() > BATCH_SIZE) {
                    boolean isOk = false;
                    while (!isOk) {
                        try {
                            System.out.println("perform");
                            builder.withReqId("doload-" + totalCounter.get()).perform();
                            isOk = true;
                        } catch (Throwable t) {
                            isOk = false;
                            System.out.println(t);
                            System.out.println("sleep for 1 min before retry");
                            try {
                                Thread.sleep(6000L);
                            } catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    ref.set(dispenser.quotas().changeInService("nirvana"));
                    counter.set(0);
                    System.out.println(totalCounter + " lines");
                    System.out.println("totl time: " + ((System.currentTimeMillis() - start) / 60000.) + " min");
                    System.out.println("speed: " + (totalCounter.get() * 1. / ((System.currentTimeMillis() - start) / 60000.)));
                    System.out.println("CHUNK " + CHUNK.get());
                    System.out.println("NODE " + NODE.get());
                    System.out.println("DISK " + DISK.get());
                }
            });

            System.out.println("LAST PERFORM");

            ref.get().withReqId("doload-last").perform();
        }

        System.out.println("totl time: " + ((System.currentTimeMillis() - start) / 60000.) + " min");
        System.out.println("CHUNK " + CHUNK.get());
        System.out.println("NODE " + NODE.get());
        System.out.println("DISK " + DISK.get());
    }

    private static boolean parse(@NotNull final String line, @NotNull final BatchQuotaChangeRequestBuilder builder) {
        final String[] parts = line.split("\\s+");
//uid \t path \t disk_space \t chunk_count \t node_count \t usage_count \t used_by
        final String key = parts[0];
        int count = Integer.parseInt(parts[5]);
        final long disk = Long.parseLong(parts[2]);
        final long chunks = Long.parseLong(parts[3]);
        final long nodes = Long.parseLong(parts[4]);

        final String user = parts[6].split(",")[0].trim();


        if (usages.containsKey(key) && usages.get(key).containsKey(user)) {
            if (usages.get(key).get(user).equals((long) count)) {
                return false;
            } else {
                count = (int) (count - usages.get(key).get(user));
                assert count > 0;
            }
        }

        if (createdIdSet.contains(key)) {
            if (count > 0) {
                builder.shareEntity(
                        DiEntityUsage.of(DiEntity.withKey(key)
                                        .bySpecification("yt-file")
                                        .occupies("yt-disk", DiAmount.of(disk, DiUnit.BYTE))
                                        .occupies("yt-chunk", DiAmount.of(chunks, DiUnit.COUNT))
                                        .occupies("yt-node", DiAmount.of(nodes, DiUnit.COUNT))
                                        .build(),
                                count), DiPerformer.login(user).chooses("default"));
            } else {
                count = -count;
                builder.releaseEntitySharing(DiEntityUsage.of(DiEntityReference.withKey(key)
                        .bySpecification("yt-file").build(), count), DiPerformer.login(user).chooses("default"));
            }
        } else {
            DISK.addAndGet(disk);
            CHUNK.addAndGet(chunks);
            NODE.addAndGet(nodes);

            createdIdSet.add(key);
            builder.createEntity(
                    DiEntity.withKey(key)
                            .bySpecification("yt-file")
                            .occupies("yt-disk", DiAmount.of(disk, DiUnit.BYTE))
                            .occupies("yt-chunk", DiAmount.of(chunks, DiUnit.COUNT))
                            .occupies("yt-node", DiAmount.of(nodes, DiUnit.COUNT))
                            .build(),
                    DiPerformer.login(user).chooses("default")
            );
            if (count > 1) {
                builder.shareEntity(
                        DiEntityUsage.of(DiEntity.withKey(key)
                                        .bySpecification("yt-file")
                                        .occupies("yt-disk", DiAmount.of(disk, DiUnit.BYTE))
                                        .occupies("yt-chunk", DiAmount.of(chunks, DiUnit.COUNT))
                                        .occupies("yt-node", DiAmount.of(nodes, DiUnit.COUNT))
                                        .build(),
                                count - 1), DiPerformer.login(user).chooses("default")
                );
            }
        }
        return true;
    }

    private static void parseOld(@NotNull final String line) {
        final String[] parts = line.split("\\s+");
//uid \t path \t disk_space \t chunk_count \t node_count \t usage_count \t used_by
        final String key = parts[0];
        final int count = Integer.parseInt(parts[5]);
        final long disk = Long.parseLong(parts[2]);
        final long chunks = Long.parseLong(parts[3]);
        final long nodes = Long.parseLong(parts[4]);

        final String user = parts[6].split(",")[0].trim();

//    System.out.println("user " + user);
        if (createdIdSet.contains(key)) {
            usages.get(key).putIfAbsent(user, (long) count);
        } else {
            DISK.addAndGet(disk);
            CHUNK.addAndGet(chunks);
            NODE.addAndGet(nodes);
            createdIdSet.add(key);
            usages.put(key, new HashMap<>());
            usages.get(key).putIfAbsent(user, (long) count);
        }
    }
}
