package ru.yandex.qe.dispenser.ws.admin;

import java.net.URISyntaxException;

import javax.inject.Inject;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

import io.swagger.annotations.Api;
import io.swagger.annotations.Authorization;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

import ru.yandex.inside.goals.GoalsClient;
import ru.yandex.qe.dispenser.api.v1.response.DiResponse;
import ru.yandex.qe.dispenser.domain.dao.goal.GoalDao;
import ru.yandex.qe.dispenser.swagger.DispenserSecurityDefinition;
import ru.yandex.qe.dispenser.swagger.SwaggerTags;
import ru.yandex.qe.dispenser.ws.Access;
import ru.yandex.qe.dispenser.ws.ServiceBase;
import ru.yandex.qe.dispenser.ws.goal.GoalSyncTask;
import ru.yandex.qe.dispenser.ws.goal.TrackerGoalClient;
import ru.yandex.qe.dispenser.ws.goal.TrackerGoalHelper;

@Service("admin-goal")
@Path("/admin/goals")
@Produces(ServiceBase.APPLICATION_JSON_UTF_8)
@Api(tags = {SwaggerTags.DISPENSER_API}, authorizations = {@Authorization(value = DispenserSecurityDefinition.AUTHORIZATION_SCHEME_NAME)})
public class GoalAdminService {

    private final GoalSyncTask goalSyncTask;
    private final Environment env;
    private final TrackerGoalHelper trackerGoalHelper;

    @Inject
    public GoalAdminService(final Environment env,
                            final GoalDao goalDao,
                            @Value("${goal.service.url}") final String goalBaseUrl,
                            @Value("${goal.oauth.token}") final String token,
                            @Value("${goal.sync.from.tracker}") final boolean syncFromTracker,
                            final TrackerGoalClient trackerGoalClient, final TrackerGoalHelper trackerGoalHelper) throws URISyntaxException {
        this.trackerGoalHelper = trackerGoalHelper;
        this.env = env;
        goalSyncTask = new GoalSyncTask(goalDao, new GoalsClient(goalBaseUrl, token), syncFromTracker, trackerGoalClient, trackerGoalHelper);
    }

    @POST
    @Path("_sync")
    @Access(dispenserAdmin = true)
    public DiResponse syncGoals() {
        if (!env.acceptsProfiles("goal-sync")) {
            return new DiResponse(Response.Status.FORBIDDEN.getStatusCode());
        }

        try {
            goalSyncTask.update();
        } catch (RuntimeException e) {
            return new DiResponse(Response.Status.BAD_REQUEST.getStatusCode());
        }
        return new DiResponse(Response.Status.OK.getStatusCode());
    }
}
