package ru.yandex.qe.dispenser.ws.admin;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

@SuppressWarnings("UseOfSystemOutOrSystemErr")
public final class IndependentCheck {
    private IndependentCheck() {
    }

    public static void main(@NotNull final String[] args) throws IOException {
        final long[] disk = new long[1];
        final long[] node = new long[1];
        final long[] chunk = new long[1];
        final Set<String> keys = new HashSet<>();
        FileUtils.readLines(new File("/Users/amosov-f/production_dump.tsv")).forEach(line -> {
            final String[] parts = line.split("\\s+");
            final String key = parts[0];
            if (keys.contains(key)) {
                return;
            }
            keys.add(key);
            disk[0] += Long.parseLong(parts[2]);
            node[0] += Long.parseLong(parts[3]);
            chunk[0] += Long.parseLong(parts[4]);
        });
        System.out.println(disk[0]);
        System.out.println(node[0]);
        System.out.println(chunk[0]);
    }
}
