package ru.yandex.qe.dispenser.ws.admin;

import java.util.Map;

import javax.ws.rs.Path;

import com.google.common.collect.ImmutableMap;
import io.swagger.annotations.Api;
import io.swagger.annotations.Authorization;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.qe.dispenser.solomon.Solomon;
import ru.yandex.qe.dispenser.swagger.DispenserSecurityDefinition;
import ru.yandex.qe.dispenser.swagger.SwaggerTags;

@Service("table")
@Path("/table")
@Api(tags = {SwaggerTags.DISPENSER_API}, authorizations = {@Authorization(value = DispenserSecurityDefinition.AUTHORIZATION_SCHEME_NAME)})
public class TablePage extends AdminPageBase {
    @Autowired
    private Solomon solomon;

    @NotNull
    @Override
    public String getPathInBundle() {
        return "table.ftl";
    }

    @NotNull
    @Override
    public Map<String, Object> getDataModel(@Nullable final String whoami) {
        return ImmutableMap.<String, Object>builder()
                .putAll(super.getDataModel(whoami))
                .put("solomon", solomon)
                .build();
    }
}
