package ru.yandex.qe.dispenser.ws.allocation;

import ru.yandex.qe.dispenser.domain.i18n.LocalizableString;

public class AllocationError {
    private final LocalizableString message;
    private final boolean isTransient;

    public AllocationError(LocalizableString message, boolean isTransient) {
        this.message = message;
        this.isTransient = isTransient;
    }

    public static AllocationError transientError(LocalizableString message) {
        return new AllocationError(message, true);
    }

    public static AllocationError notTransientError(LocalizableString message) {
        return new AllocationError(message, false);
    }

    public boolean isTransient() {
        return isTransient;
    }

    public LocalizableString getMessage() {
        return message;
    }
}
