package ru.yandex.qe.dispenser.ws.allocation;

import ru.yandex.qe.dispenser.domain.Service;
import ru.yandex.qe.dispenser.domain.i18n.LocalizableString;

import java.util.List;
import java.util.Objects;

public class ProviderAllocationInfo {
    private final Service provider;
    private final boolean canAllocate;
    private final List<LocalizableString> notes;
    private final boolean hasAllocatingResources;

    public ProviderAllocationInfo(Service provider, boolean canAllocate, List<LocalizableString> notes, boolean hasAllocatingResources) {
        this.provider = provider;
        this.canAllocate = canAllocate;
        this.notes = notes;
        this.hasAllocatingResources = hasAllocatingResources;
    }

    public Service getProvider() {
        return provider;
    }

    public boolean canAllocate() {
        return canAllocate;
    }

    public List<LocalizableString> getNotes() {
        return notes;
    }

    public boolean hasAllocatingResources() {
        return hasAllocatingResources;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProviderAllocationInfo that = (ProviderAllocationInfo) o;
        return Objects.equals(getProvider(), that.getProvider());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getProvider());
    }
}
