package ru.yandex.qe.dispenser.ws.allocation;

import com.google.common.collect.ImmutableMap;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum YpResource {
    CPU("cpu"),
    RAM("ram"),
    HDD("hdd"),
    SSD("ssd"),
    IO_HDD("io_hdd"),
    IO_SSD("io_ssd"),
    ;

    private static final Map<String, YpResource> YP_RESOURCE_KEY_MAPPER = ImmutableMap.<String, YpResource>builder()
            .put("cpu_segmented", CPU)
            .put("ram_segmented", RAM)
            .put("ssd_segmented", SSD)
            .put("hdd_segmented", HDD)
            .putAll(Arrays.stream(values())
                    .collect(Collectors.toMap(YpResource::getKey, v -> v)))
            .build();

    private final String key;

    YpResource(String key) {
        this.key = key;
    }

    public String getKey() {
        return key;
    }

    public static YpResource from(String key) {
        return YP_RESOURCE_KEY_MAPPER.get(key);
    }
}
