package ru.yandex.qe.dispenser.ws.allocation;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import ru.yandex.qe.dispenser.client.v1.impl.DispenserConfig;
import ru.yandex.qe.dispenser.domain.MessageHelper;
import ru.yandex.qe.dispenser.domain.tracker.TrackerManager;
import ru.yandex.qe.dispenser.ws.bot.Provider;

@Component
@ParametersAreNonnullByDefault
public class YtRequestAllocationWorkflow extends AssigneeAndSummonRequestAllocationWorkflow {

    private static final String PROVIDER_PROPERTY_KEY = "yt";
    private static final String ASSIGNEE_DEFAULT = "andozer";

    public YtRequestAllocationWorkflow(final TrackerManager trackerManager, final MessageHelper messageHelper,
                                       @Value("${qe.app.environment}") final DispenserConfig.Environment environment,
                                       @Value("${dispenser.cluster.prefix}") final String clusterPrefix) {
        super(Provider.YT, trackerManager, messageHelper, environment, clusterPrefix, PROVIDER_PROPERTY_KEY, ASSIGNEE_DEFAULT);
    }
}
