package ru.yandex.qe.dispenser.ws.api.model.distribution;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
public final class QuotaDistributionPlan {

    @NotNull
    private final DistributedQuota distributedQuota;
    @NotNull
    private final DistributedQuotaDeltas distributedQuotaDeltas;

    @JsonCreator
    public QuotaDistributionPlan(@JsonProperty("distributedQuota") @NotNull final DistributedQuota distributedQuota,
                                  @JsonProperty("distributedQuotaDeltas") @NotNull final DistributedQuotaDeltas distributedQuotaDeltas) {
        this.distributedQuota = distributedQuota;
        this.distributedQuotaDeltas = distributedQuotaDeltas;
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public DistributedQuota getDistributedQuota() {
        return distributedQuota;
    }

    @NotNull
    public DistributedQuotaDeltas getDistributedQuotaDeltas() {
        return distributedQuotaDeltas;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final QuotaDistributionPlan that = (QuotaDistributionPlan) o;
        return Objects.equals(distributedQuota, that.distributedQuota) &&
                Objects.equals(distributedQuotaDeltas, that.distributedQuotaDeltas);
    }

    @Override
    public int hashCode() {
        return Objects.hash(distributedQuota, distributedQuotaDeltas);
    }

    @Override
    public String toString() {
        return "QuotaDistributionPlan{" +
                "distributedQuota=" + distributedQuota +
                ", distributedQuotaDeltas=" + distributedQuotaDeltas +
                '}';
    }

    public static final class Builder {

        @Nullable
        private DistributedQuota distributedQuota;
        @Nullable
        private DistributedQuotaDeltas distributedQuotaDeltas;

        private Builder() {
        }

        @NotNull
        public Builder distributedQuota(@NotNull final DistributedQuota distributedQuota) {
            Objects.requireNonNull(distributedQuota, "Distributed quota is required.");
            this.distributedQuota = distributedQuota;
            return this;
        }

        @NotNull
        public Builder distributedQuotaDeltas(@NotNull final DistributedQuotaDeltas distributedQuotaDeltas) {
            Objects.requireNonNull(distributedQuotaDeltas, "Distributed quota deltas are required.");
            this.distributedQuotaDeltas = distributedQuotaDeltas;
            return this;
        }

        @Nullable
        public DistributedQuota getDistributedQuota() {
            return distributedQuota;
        }

        @Nullable
        public DistributedQuotaDeltas getDistributedQuotaDeltas() {
            return distributedQuotaDeltas;
        }

        @NotNull
        public QuotaDistributionPlan build() {
            Objects.requireNonNull(distributedQuota, "Distributed quota is required.");
            Objects.requireNonNull(distributedQuotaDeltas, "Distributed quota deltas are required.");
            return new QuotaDistributionPlan(distributedQuota, distributedQuotaDeltas);
        }

        @Override
        public boolean equals(final Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            final Builder builder = (Builder) o;
            return Objects.equals(distributedQuota, builder.distributedQuota) &&
                    Objects.equals(distributedQuotaDeltas, builder.distributedQuotaDeltas);
        }

        @Override
        public int hashCode() {
            return Objects.hash(distributedQuota, distributedQuotaDeltas);
        }

        @Override
        public String toString() {
            return "Builder{" +
                    "distributedQuota=" + distributedQuota +
                    ", distributedQuotaDeltas=" + distributedQuotaDeltas +
                    '}';
        }

    }

}
