package ru.yandex.qe.dispenser.ws.api.model.distribution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

import ru.yandex.qe.dispenser.domain.QuotaChangeRequest;
import ru.yandex.qe.dispenser.domain.Service;

public class ValidatedAllocationDestinationSelectionQuotaRequest {

    private final QuotaChangeRequest request;
    private final List<Service> providers;

    private ValidatedAllocationDestinationSelectionQuotaRequest(QuotaChangeRequest request, List<Service> providers) {
        this.request = request;
        this.providers = providers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public QuotaChangeRequest getRequest() {
        return request;
    }

    public List<Service> getProviders() {
        return providers;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ValidatedAllocationDestinationSelectionQuotaRequest that =
                (ValidatedAllocationDestinationSelectionQuotaRequest) o;
        return Objects.equals(request, that.request) && Objects.equals(providers, that.providers);
    }

    @Override
    public int hashCode() {
        return Objects.hash(request, providers);
    }

    @Override
    public String toString() {
        return "ValidatedAllocationDestinationSelectionQuotaRequest{" +
                "request=" + request +
                ", providers=" + providers +
                '}';
    }

    public static final class Builder {

        private QuotaChangeRequest request;
        private final List<Service> providers = new ArrayList<>();

        private Builder() {
        }

        public Builder request(QuotaChangeRequest request) {
            this.request = request;
            return this;
        }

        public Builder addProvider(Service provider) {
            this.providers.add(provider);
            return this;
        }

        public Builder addProviders(Collection<? extends Service> providers) {
            this.providers.addAll(providers);
            return this;
        }

        public ValidatedAllocationDestinationSelectionQuotaRequest build() {
            Objects.requireNonNull(request, "Request is required");
            return new ValidatedAllocationDestinationSelectionQuotaRequest(request, providers);
        }

    }

}
