package ru.yandex.qe.dispenser.ws.api.model.distribution;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import ru.yandex.qe.dispenser.domain.Person;

public final class ValidatedAllocationDestinationSelectionRequest {

    private final List<ValidatedAllocationDestinationSelectionQuotaRequest> requests;
    private final Person author;

    private ValidatedAllocationDestinationSelectionRequest(
            List<ValidatedAllocationDestinationSelectionQuotaRequest> requests,
            Person author) {
        this.requests = requests;
        this.author = author;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<ValidatedAllocationDestinationSelectionQuotaRequest> getRequests() {
        return requests;
    }

    public Person getAuthor() {
        return author;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ValidatedAllocationDestinationSelectionRequest that = (ValidatedAllocationDestinationSelectionRequest) o;
        return Objects.equals(requests, that.requests);
    }

    @Override
    public int hashCode() {
        return Objects.hash(requests);
    }

    @Override
    public String toString() {
        return "ValidatedAllocationDestinationSelectionRequest{" +
                "requests=" + requests +
                '}';
    }

    public static final class Builder {

        private final List<ValidatedAllocationDestinationSelectionQuotaRequest> requests = new ArrayList<>();
        private Person author;

        private Builder() {
        }

        public Builder addRequest(ValidatedAllocationDestinationSelectionQuotaRequest request) {
            this.requests.add(request);
            return this;
        }

        public Builder author(Person author) {
            this.author = author;
            return this;
        }

        public ValidatedAllocationDestinationSelectionRequest build() {
            Objects.requireNonNull(author, "Author is required");
            return new ValidatedAllocationDestinationSelectionRequest(requests, author);
        }

    }

}
