package ru.yandex.qe.dispenser.ws.aspect;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

import ru.yandex.qe.dispenser.domain.aspect.AspectBase;
import ru.yandex.qe.dispenser.ws.Mutator;

@Component
@Profile("abc-sync")
@Aspect
public class ProjectReadOnlyAspect extends AspectBase {
    @Before("execution(public * ru.yandex.qe.dispenser.ws.ProjectService.*(..)) && @annotation(mutator)")
    public void around(@NotNull final JoinPoint jp, @NotNull final Mutator mutator) {
        throw new IllegalArgumentException("Can't modify projects in read-only mode");
    }
}
