package ru.yandex.qe.dispenser.ws.base_resources;

import java.util.Set;

import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

import ru.yandex.qe.dispenser.domain.hierarchy.Session;
import ru.yandex.qe.dispenser.swagger.DispenserSecurityDefinition;
import ru.yandex.qe.dispenser.swagger.SwaggerTags;
import ru.yandex.qe.dispenser.ws.Access;
import ru.yandex.qe.dispenser.ws.ServiceBase;
import ru.yandex.qe.dispenser.ws.base_resources.impl.BaseResourceMappingsManager;
import ru.yandex.qe.dispenser.ws.base_resources.model.BaseResourceMappingsPageDto;
import ru.yandex.qe.dispenser.ws.base_resources.model.ExpandBaseResourceMapping;
import ru.yandex.qe.dispenser.ws.base_resources.model.SingleBaseResourceMappingDto;
import ru.yandex.qe.dispenser.ws.common.domain.errors.ErrorCollection;
import ru.yandex.qe.dispenser.ws.common.domain.errors.TypedError;
import ru.yandex.qe.dispenser.ws.common.domain.result.Result;
import ru.yandex.qe.dispenser.ws.common.impl.ResultToResponse;
import ru.yandex.qe.dispenser.ws.common.model.response.ErrorResponse;

@Path("/v1/base-resource-mappings")
@Produces(ServiceBase.APPLICATION_JSON_UTF_8)
@Service("base-resource-mappings")
@Api(tags = {SwaggerTags.DISPENSER_API}, authorizations = {@Authorization(value = DispenserSecurityDefinition.AUTHORIZATION_SCHEME_NAME)})
public class BaseResourceMappingsService {

    private final BaseResourceMappingsManager baseResourceMappingsManager;

    @Inject
    public BaseResourceMappingsService(BaseResourceMappingsManager baseResourceMappingsManager) {
        this.baseResourceMappingsManager = baseResourceMappingsManager;
    }

    @GET
    @Access
    @NotNull
    @ApiOperation(value = "Get base resource mappings page")
    @ApiResponses({@ApiResponse(code = 200, message = "Successful response", response = BaseResourceMappingsPageDto.class),
            @ApiResponse(code = 400, message = "Illegal argument response", response = ErrorResponse.class)})
    public Response getPage(@Nullable @QueryParam("from") Long from,
                            @Nullable @QueryParam("limit") Integer limit,
                            @Nullable @QueryParam("expand") Set<ExpandBaseResourceMapping> expand) {
        Result<BaseResourceMappingsPageDto, ErrorCollection<String, TypedError<String>>> result
                = baseResourceMappingsManager.getPage(from, limit, Session.USER_LOCALE.get(), expand);
        return ResultToResponse.toResponse(result);
    }

    @GET
    @Access
    @NotNull
    @Path("/{id}")
    @ApiOperation(value = "Get base resource mapping")
    @ApiResponses({@ApiResponse(code = 200, message = "Successful response", response = SingleBaseResourceMappingDto.class),
            @ApiResponse(code = 404, message = "'Not found' response", response = ErrorResponse.class)})
    public Response getById(@PathParam("id") long id,
                            @Nullable @QueryParam("expand") Set<ExpandBaseResourceMapping> expand) {
        Result<SingleBaseResourceMappingDto, ErrorCollection<String, TypedError<String>>> result
                = baseResourceMappingsManager.getById(id, Session.USER_LOCALE.get(), expand);
        return ResultToResponse.toResponse(result);
    }

}
