package ru.yandex.qe.dispenser.ws.base_resources;

import java.util.Set;

import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

import ru.yandex.qe.dispenser.domain.hierarchy.Session;
import ru.yandex.qe.dispenser.swagger.DispenserSecurityDefinition;
import ru.yandex.qe.dispenser.swagger.SwaggerTags;
import ru.yandex.qe.dispenser.ws.Access;
import ru.yandex.qe.dispenser.ws.ServiceBase;
import ru.yandex.qe.dispenser.ws.base_resources.impl.BaseResourceTypesManager;
import ru.yandex.qe.dispenser.ws.base_resources.model.BaseResourceTypesPageDto;
import ru.yandex.qe.dispenser.ws.base_resources.model.ExpandBaseResourceType;
import ru.yandex.qe.dispenser.ws.base_resources.model.SingleBaseResourceTypeDto;
import ru.yandex.qe.dispenser.ws.common.domain.errors.ErrorCollection;
import ru.yandex.qe.dispenser.ws.common.domain.errors.TypedError;
import ru.yandex.qe.dispenser.ws.common.domain.result.Result;
import ru.yandex.qe.dispenser.ws.common.impl.ResultToResponse;
import ru.yandex.qe.dispenser.ws.common.model.response.ErrorResponse;

@Path("/v1/base-resource-types")
@Produces(ServiceBase.APPLICATION_JSON_UTF_8)
@Service("base-resource-types")
@Api(tags = {SwaggerTags.DISPENSER_API}, authorizations = {@Authorization(value = DispenserSecurityDefinition.AUTHORIZATION_SCHEME_NAME)})
public class BaseResourceTypesService {

    private final BaseResourceTypesManager baseResourceTypesManager;

    @Inject
    public BaseResourceTypesService(BaseResourceTypesManager baseResourceTypesManager) {
        this.baseResourceTypesManager = baseResourceTypesManager;
    }

    @GET
    @Access
    @NotNull
    @ApiOperation(value = "Get base resource types page")
    @ApiResponses({@ApiResponse(code = 200, message = "Successful response", response = BaseResourceTypesPageDto.class),
            @ApiResponse(code = 400, message = "Illegal argument response", response = ErrorResponse.class)})
    public Response getPage(@Nullable @QueryParam("from") Long from,
                            @Nullable @QueryParam("limit") Integer limit,
                            @Nullable @QueryParam("expand") Set<ExpandBaseResourceType> expand) {
        Result<BaseResourceTypesPageDto, ErrorCollection<String, TypedError<String>>> result = baseResourceTypesManager
                .getPage(from, limit, Session.USER_LOCALE.get(), expand);
        return ResultToResponse.toResponse(result);
    }

    @GET
    @Access
    @NotNull
    @Path("/{id}")
    @ApiOperation(value = "Get base resource type")
    @ApiResponses({@ApiResponse(code = 200, message = "Successful response", response = SingleBaseResourceTypeDto.class),
            @ApiResponse(code = 404, message = "'Not found' response", response = ErrorResponse.class)})
    public Response getById(@PathParam("id") long id,
                            @Nullable @QueryParam("expand") Set<ExpandBaseResourceType> expand) {
        Result<SingleBaseResourceTypeDto, ErrorCollection<String, TypedError<String>>> result = baseResourceTypesManager
                .getById(id, Session.USER_LOCALE.get(), expand);
        return ResultToResponse.toResponse(result);
    }

}
