package ru.yandex.qe.dispenser.ws.base_resources.impl;

import java.util.Objects;
import java.util.Set;

import ru.yandex.qe.dispenser.domain.Segment;
import ru.yandex.qe.dispenser.domain.Service;
import ru.yandex.qe.dispenser.domain.base_resources.BaseResource;
import ru.yandex.qe.dispenser.domain.base_resources.BaseResourceType;
import ru.yandex.qe.dispenser.domain.bot.BigOrder;

public final class BigOrderBaseResourceAmount {

    private final BigOrder bigOrder;
    private final BaseResource baseResource;
    private final BaseResourceType baseResourceType;
    private final Set<Segment> baseResourceSegments;
    private final Service service;
    private final long amount;
    private final Set<PerServiceBaseResourceAmount> perServiceAmounts;

    public BigOrderBaseResourceAmount(BigOrder bigOrder,
                                      BaseResource baseResource,
                                      BaseResourceType baseResourceType,
                                      Set<Segment> baseResourceSegments,
                                      Service service,
                                      long amount,
                                      Set<PerServiceBaseResourceAmount> perServiceAmounts) {
        this.bigOrder = bigOrder;
        this.baseResource = baseResource;
        this.baseResourceType = baseResourceType;
        this.baseResourceSegments = baseResourceSegments;
        this.service = service;
        this.amount = amount;
        this.perServiceAmounts = perServiceAmounts;
    }

    public BigOrder getBigOrder() {
        return bigOrder;
    }

    public BaseResource getBaseResource() {
        return baseResource;
    }

    public BaseResourceType getBaseResourceType() {
        return baseResourceType;
    }

    public Set<Segment> getBaseResourceSegments() {
        return baseResourceSegments;
    }

    public Service getService() {
        return service;
    }

    public long getAmount() {
        return amount;
    }

    public Set<PerServiceBaseResourceAmount> getPerServiceAmounts() {
        return perServiceAmounts;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BigOrderBaseResourceAmount that = (BigOrderBaseResourceAmount) o;
        return amount == that.amount &&
                Objects.equals(bigOrder, that.bigOrder) &&
                Objects.equals(baseResource, that.baseResource) &&
                Objects.equals(baseResourceType, that.baseResourceType) &&
                Objects.equals(baseResourceSegments, that.baseResourceSegments) &&
                Objects.equals(service, that.service) &&
                Objects.equals(perServiceAmounts, that.perServiceAmounts);
    }

    @Override
    public int hashCode() {
        return Objects.hash(bigOrder, baseResource, baseResourceType, baseResourceSegments, service,
                amount, perServiceAmounts);
    }

    @Override
    public String toString() {
        return "BigOrderBaseResourceAmount{" +
                "bigOrder=" + bigOrder +
                ", baseResource=" + baseResource +
                ", baseResourceType=" + baseResourceType +
                ", baseResourceSegments=" + baseResourceSegments +
                ", service=" + service +
                ", amount=" + amount +
                ", perServiceAmounts=" + perServiceAmounts +
                '}';
    }

}
