package ru.yandex.qe.dispenser.ws.base_resources.impl;

import java.util.Objects;
import java.util.Set;

import ru.yandex.qe.dispenser.domain.Service;

public final class PerServiceBaseResourceAmount {

    private final Service service;
    private final long amount;
    private final Set<Long> mappingIds;

    public PerServiceBaseResourceAmount(Service service, long amount, Set<Long> mappingIds) {
        this.service = service;
        this.amount = amount;
        this.mappingIds = mappingIds;
    }

    public Service getService() {
        return service;
    }

    public long getAmount() {
        return amount;
    }

    public Set<Long> getMappingIds() {
        return mappingIds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PerServiceBaseResourceAmount that = (PerServiceBaseResourceAmount) o;
        return amount == that.amount &&
                Objects.equals(service, that.service) &&
                Objects.equals(mappingIds, that.mappingIds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(service, amount, mappingIds);
    }

    @Override
    public String toString() {
        return "PerServiceBaseResourceAmount{" +
                "service=" + service +
                ", amount=" + amount +
                ", mappingIds=" + mappingIds +
                '}';
    }

}
