package ru.yandex.qe.dispenser.ws.base_resources.impl;

import java.util.Objects;
import java.util.Set;

public final class QuotaChangeRequestBaseResources {

    private final Set<BigOrderBaseResourceAmount> amounts;

    public QuotaChangeRequestBaseResources(Set<BigOrderBaseResourceAmount> amounts) {
        this.amounts = amounts;
    }

    public Set<BigOrderBaseResourceAmount> getAmounts() {
        return amounts;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        QuotaChangeRequestBaseResources that = (QuotaChangeRequestBaseResources) o;
        return Objects.equals(amounts, that.amounts);
    }

    @Override
    public int hashCode() {
        return Objects.hash(amounts);
    }

    @Override
    public String toString() {
        return "QuotaChangeRequestBaseResources{" +
                "amounts=" + amounts +
                '}';
    }

}
