package ru.yandex.qe.dispenser.ws.base_resources.model;

import java.util.Objects;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
@ApiModel("Base resource")
public final class BaseResourceDto {

    private final long id;
    private final String key;
    private final String name;
    private final long baseResourceTypeId;
    private final Set<Long> segmentIds;

    @JsonCreator
    public BaseResourceDto(@JsonProperty("id") long id,
                           @JsonProperty("key") String key,
                           @JsonProperty("name") String name,
                           @JsonProperty("baseResourceTypeId") long baseResourceTypeId,
                           @JsonProperty("segmentIds") Set<Long> segmentIds) {
        this.id = id;
        this.key = key;
        this.name = name;
        this.baseResourceTypeId = baseResourceTypeId;
        this.segmentIds = segmentIds;
    }

    @ApiModelProperty("Base resource id")
    public long getId() {
        return id;
    }

    @ApiModelProperty("Base resource key")
    public String getKey() {
        return key;
    }

    @ApiModelProperty("Base resource name")
    public String getName() {
        return name;
    }

    @ApiModelProperty("Base resource type id")
    public long getBaseResourceTypeId() {
        return baseResourceTypeId;
    }

    @ApiModelProperty("Base resource segment id set")
    public Set<Long> getSegmentIds() {
        return segmentIds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BaseResourceDto that = (BaseResourceDto) o;
        return id == that.id &&
                baseResourceTypeId == that.baseResourceTypeId &&
                Objects.equals(key, that.key) &&
                Objects.equals(name, that.name) &&
                Objects.equals(segmentIds, that.segmentIds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, key, name, baseResourceTypeId, segmentIds);
    }

    @Override
    public String toString() {
        return "BaseResourceDto{" +
                "id=" + id +
                ", key='" + key + '\'' +
                ", name='" + name + '\'' +
                ", baseResourceTypeId=" + baseResourceTypeId +
                ", segmentIds=" + segmentIds +
                '}';
    }

}
