package ru.yandex.qe.dispenser.ws.base_resources.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.qe.dispenser.api.v1.DiAmount;

@JsonIgnoreProperties(ignoreUnknown = true)
@ApiModel("Base resource limit amount")
public final class BaseResourceLimitAmountDto {

    private final DiAmount limit;

    @JsonCreator
    public BaseResourceLimitAmountDto(@JsonProperty("limit") DiAmount limit) {
        this.limit = limit;
    }

    @ApiModelProperty("Limit value")
    @JsonSerialize(using = DiAmount.CompactSerializer.class)
    public DiAmount getLimit() {
        return limit;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BaseResourceLimitAmountDto that = (BaseResourceLimitAmountDto) o;
        return Objects.equals(limit, that.limit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(limit);
    }

    @Override
    public String toString() {
        return "BaseResourceLimitAmountDto{" +
                "limit=" + limit +
                '}';
    }

}
