package ru.yandex.qe.dispenser.ws.base_resources.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.qe.dispenser.api.v1.DiAmount;

@JsonIgnoreProperties(ignoreUnknown = true)
@ApiModel("Base resource limit")
public final class BaseResourceLimitDto {

    private final long id;
    private final long baseResourceId;
    private final long campaignId;
    private final long providerId;
    private final DiAmount limit;

    @JsonCreator
    public BaseResourceLimitDto(@JsonProperty("id") long id,
                                @JsonProperty("baseResourceId") long baseResourceId,
                                @JsonProperty("campaignId") long campaignId,
                                @JsonProperty("providerId") long providerId,
                                @JsonProperty("limit") DiAmount limit) {
        this.id = id;
        this.baseResourceId = baseResourceId;
        this.campaignId = campaignId;
        this.providerId = providerId;
        this.limit = limit;
    }

    @ApiModelProperty("Base resource limit id")
    public long getId() {
        return id;
    }

    @ApiModelProperty("Base resource id")
    public long getBaseResourceId() {
        return baseResourceId;
    }

    @ApiModelProperty("Campaign id")
    public long getCampaignId() {
        return campaignId;
    }

    @ApiModelProperty("Provider id")
    public long getProviderId() {
        return providerId;
    }

    @ApiModelProperty("Limit value")
    public DiAmount getLimit() {
        return limit;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BaseResourceLimitDto that = (BaseResourceLimitDto) o;
        return id == that.id &&
                baseResourceId == that.baseResourceId &&
                campaignId == that.campaignId &&
                providerId == that.providerId &&
                Objects.equals(limit, that.limit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, baseResourceId, campaignId, providerId, limit);
    }

    @Override
    public String toString() {
        return "BaseResourceLimitDto{" +
                "id=" + id +
                ", baseResourceId=" + baseResourceId +
                ", campaignId=" + campaignId +
                ", providerId=" + providerId +
                ", limit=" + limit +
                '}';
    }

}
