package ru.yandex.qe.dispenser.ws.base_resources.model;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
@ApiModel("Base resource limit key")
public class BaseResourceLimitKeyDto {

    private final Long baseResourceId;
    private final Long campaignId;

    @JsonCreator
    public BaseResourceLimitKeyDto(@JsonProperty("baseResourceId") Long baseResourceId,
                                   @JsonProperty("campaignId") Long campaignId) {
        this.baseResourceId = baseResourceId;
        this.campaignId = campaignId;
    }

    @ApiModelProperty("Base resource id")
    public Optional<Long> getBaseResourceId() {
        return Optional.ofNullable(baseResourceId);
    }

    @ApiModelProperty("Campaign id")
    public Optional<Long> getCampaignId() {
        return Optional.ofNullable(campaignId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BaseResourceLimitKeyDto that = (BaseResourceLimitKeyDto) o;
        return Objects.equals(baseResourceId, that.baseResourceId) &&
                Objects.equals(campaignId, that.campaignId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(baseResourceId, campaignId);
    }

    @Override
    public String toString() {
        return "BaseResourceLimitKeyDto{" +
                "baseResourceId=" + baseResourceId +
                ", campaignId=" + campaignId +
                '}';
    }

}
