package ru.yandex.qe.dispenser.ws.base_resources.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.qe.dispenser.api.v1.DiAmount;

@JsonIgnoreProperties(ignoreUnknown = true)
@ApiModel("Base resource limit")
public final class BaseResourceLimitReportDto {

    private final String baseResourceKey;
    private final DiAmount limit;

    @JsonCreator
    public BaseResourceLimitReportDto(@JsonProperty("baseResourceKey") String baseResourceKey,
                                      @JsonProperty("limit") DiAmount limit) {
        this.baseResourceKey = baseResourceKey;
        this.limit = limit;
    }

    @ApiModelProperty("Base resource key")
    public String getBaseResourceKey() {
        return baseResourceKey;
    }

    @ApiModelProperty("Limit value")
    @JsonSerialize(using = DiAmount.CompactSerializer.class)
    public DiAmount getLimit() {
        return limit;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BaseResourceLimitReportDto that = (BaseResourceLimitReportDto) o;
        return Objects.equals(baseResourceKey, that.baseResourceKey) &&
                Objects.equals(limit, that.limit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(baseResourceKey, limit);
    }

    @Override
    public String toString() {
        return "BaseResourceLimitReportDto{" +
                "baseResourceKey='" + baseResourceKey + '\'' +
                ", limit=" + limit +
                '}';
    }

}
