package ru.yandex.qe.dispenser.ws.base_resources.model;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.qe.dispenser.api.v1.DiAmount;

@JsonIgnoreProperties(ignoreUnknown = true)
@ApiModel("Base resource limit")
public final class BaseResourceLimitReportInputDto {

    private final String baseResourceKey;
    private final DiAmount limit;

    @JsonCreator
    public BaseResourceLimitReportInputDto(@JsonProperty("baseResourceKey") String baseResourceKey,
                                           @JsonProperty("limit") DiAmount limit) {
        this.baseResourceKey = baseResourceKey;
        this.limit = limit;
    }

    @ApiModelProperty("Base resource key")
    public Optional<String> getBaseResourceKey() {
        return Optional.ofNullable(baseResourceKey);
    }

    @ApiModelProperty("Limit value")
    public Optional<DiAmount> getLimit() {
        return Optional.ofNullable(limit);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BaseResourceLimitReportInputDto that = (BaseResourceLimitReportInputDto) o;
        return Objects.equals(baseResourceKey, that.baseResourceKey) &&
                Objects.equals(limit, that.limit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(baseResourceKey, limit);
    }

    @Override
    public String toString() {
        return "BaseResourceLimitReportInputDto{" +
                "baseResourceKey='" + baseResourceKey + '\'' +
                ", limit=" + limit +
                '}';
    }

}
