package ru.yandex.qe.dispenser.ws.base_resources.model;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
@ApiModel("Base resource limits")
public final class BaseResourceLimitsReportDto {

    private final List<BaseResourceLimitReportDto> limits;

    @JsonCreator
    public BaseResourceLimitsReportDto(@JsonProperty("limits") List<BaseResourceLimitReportDto> limits) {
        this.limits = limits;
    }

    @ApiModelProperty("Base resource limits")
    public List<BaseResourceLimitReportDto> getLimits() {
        return limits;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BaseResourceLimitsReportDto that = (BaseResourceLimitsReportDto) o;
        return Objects.equals(limits, that.limits);
    }

    @Override
    public int hashCode() {
        return Objects.hash(limits);
    }

    @Override
    public String toString() {
        return "BaseResourceLimitsReportDto{" +
                "limits=" + limits +
                '}';
    }

}
