package ru.yandex.qe.dispenser.ws.base_resources.model;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
@ApiModel("A linear relation for a base resource mapping")
public final class BaseResourceLinearRelationDto {

    private final List<BaseResourceLinearRelationTermDto> terms;
    private final long constantTermNumerator;
    private final long constantTermDenominator;

    @JsonCreator
    public BaseResourceLinearRelationDto(@JsonProperty("terms") List<BaseResourceLinearRelationTermDto> terms,
                                         @JsonProperty("constantTermNumerator") long constantTermNumerator,
                                         @JsonProperty("constantTermDenominator") long constantTermDenominator) {
        this.terms = terms;
        this.constantTermNumerator = constantTermNumerator;
        this.constantTermDenominator = constantTermDenominator;
    }

    @ApiModelProperty("Terms list")
    public List<BaseResourceLinearRelationTermDto> getTerms() {
        return terms;
    }

    @ApiModelProperty("Constant term numerator")
    public long getConstantTermNumerator() {
        return constantTermNumerator;
    }

    @ApiModelProperty("Constant term denominator")
    public long getConstantTermDenominator() {
        return constantTermDenominator;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BaseResourceLinearRelationDto that = (BaseResourceLinearRelationDto) o;
        return constantTermNumerator == that.constantTermNumerator &&
                constantTermDenominator == that.constantTermDenominator &&
                Objects.equals(terms, that.terms);
    }

    @Override
    public int hashCode() {
        return Objects.hash(terms, constantTermNumerator, constantTermDenominator);
    }

    @Override
    public String toString() {
        return "BaseResourceLinearRelationDto{" +
                "terms=" + terms +
                ", constantTermNumerator=" + constantTermNumerator +
                ", constantTermDenominator=" + constantTermDenominator +
                '}';
    }

}
