package ru.yandex.qe.dispenser.ws.base_resources.model;

import java.util.Objects;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
@ApiModel("A term of a linear relation for a base resource mapping")
public final class BaseResourceLinearRelationTermDto {

    private final long numerator;
    private final long denominator;
    private final long resourceId;
    private final Set<Long> segmentIds;

    @JsonCreator
    public BaseResourceLinearRelationTermDto(@JsonProperty("numerator") long numerator,
                                             @JsonProperty("denominator") long denominator,
                                             @JsonProperty("resourceId") long resourceId,
                                             @JsonProperty("segmentIds") Set<Long> segmentIds) {
        this.numerator = numerator;
        this.denominator = denominator;
        this.resourceId = resourceId;
        this.segmentIds = segmentIds;
    }

    @ApiModelProperty("Term factor numerator")
    public long getNumerator() {
        return numerator;
    }

    @ApiModelProperty("Term factor denominator")
    public long getDenominator() {
        return denominator;
    }

    @ApiModelProperty("Term resource id")
    public long getResourceId() {
        return resourceId;
    }

    @ApiModelProperty("Term resource segment id set")
    public Set<Long> getSegmentIds() {
        return segmentIds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BaseResourceLinearRelationTermDto that = (BaseResourceLinearRelationTermDto) o;
        return numerator == that.numerator &&
                denominator == that.denominator &&
                resourceId == that.resourceId &&
                Objects.equals(segmentIds, that.segmentIds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(numerator, denominator, resourceId, segmentIds);
    }

    @Override
    public String toString() {
        return "BaseResourceLinearRelationTermDto{" +
                "numerator=" + numerator +
                ", denominator=" + denominator +
                ", resourceId=" + resourceId +
                ", segmentIds=" + segmentIds +
                '}';
    }

}
