package ru.yandex.qe.dispenser.ws.base_resources.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
@ApiModel("A mapping for a base resource")
public final class BaseResourceMappingDto {

    private final long id;
    private final long baseResourceId;
    private final long campaignId;
    private final long bigOrderId;
    private final long providerId;
    private final BaseResourceRelationDto relation;

    @JsonCreator
    public BaseResourceMappingDto(@JsonProperty("id") long id,
                                  @JsonProperty("baseResourceId") long baseResourceId,
                                  @JsonProperty("campaignId") long campaignId,
                                  @JsonProperty("bigOrderId") long bigOrderId,
                                  @JsonProperty("providerId") long providerId,
                                  @JsonProperty("relation") BaseResourceRelationDto relation) {
        this.id = id;
        this.baseResourceId = baseResourceId;
        this.campaignId = campaignId;
        this.bigOrderId = bigOrderId;
        this.providerId = providerId;
        this.relation = relation;
    }

    @ApiModelProperty("Base resource mapping id")
    public long getId() {
        return id;
    }

    @ApiModelProperty("Base resource id")
    public long getBaseResourceId() {
        return baseResourceId;
    }

    @ApiModelProperty("Campaign id")
    public long getCampaignId() {
        return campaignId;
    }

    @ApiModelProperty("Big order id")
    public long getBigOrderId() {
        return bigOrderId;
    }

    @ApiModelProperty("Provider id")
    public long getProviderId() {
        return providerId;
    }

    @ApiModelProperty("Mapping relation")
    public BaseResourceRelationDto getRelation() {
        return relation;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BaseResourceMappingDto that = (BaseResourceMappingDto) o;
        return id == that.id &&
                baseResourceId == that.baseResourceId &&
                campaignId == that.campaignId &&
                bigOrderId == that.bigOrderId &&
                providerId == that.providerId &&
                Objects.equals(relation, that.relation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, baseResourceId, campaignId, bigOrderId, providerId, relation);
    }

    @Override
    public String toString() {
        return "BaseResourceMappingDto{" +
                "id=" + id +
                ", baseResourceId=" + baseResourceId +
                ", campaignId=" + campaignId +
                ", bigOrderId=" + bigOrderId +
                ", providerId=" + providerId +
                ", relation=" + relation +
                '}';
    }

}
