package ru.yandex.qe.dispenser.ws.base_resources.model;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
@ApiModel("An MDS relation for a base resource mapping")
public class BaseResourceMdsRelationDto {

    private final List<BaseResourceMdsRelationTermDto> terms;

    @JsonCreator
    public BaseResourceMdsRelationDto(@JsonProperty("terms") List<BaseResourceMdsRelationTermDto> terms) {
        this.terms = terms;
    }

    @ApiModelProperty("Terms list")
    public List<BaseResourceMdsRelationTermDto> getTerms() {
        return terms;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BaseResourceMdsRelationDto that = (BaseResourceMdsRelationDto) o;
        return Objects.equals(terms, that.terms);
    }

    @Override
    public int hashCode() {
        return Objects.hash(terms);
    }

    @Override
    public String toString() {
        return "BaseResourceMdsRelationDto{" +
                "terms=" + terms +
                '}';
    }

}
