package ru.yandex.qe.dispenser.ws.base_resources.model;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.qe.dispenser.domain.base_resources.MdsLocation;
import ru.yandex.qe.dispenser.domain.base_resources.MdsStorageType;

@JsonIgnoreProperties(ignoreUnknown = true)
@ApiModel("A term of an MDS relation for a base resource mapping")
public class BaseResourceMdsRelationTermDto {

    private final long resourceId;
    private final Set<Long> segmentIds;
    private final MdsLocation location;
    private final MdsStorageType storageType;
    private final long numerator;
    private final long denominator;
    private final Long abcServiceId;

    @JsonCreator
    public BaseResourceMdsRelationTermDto(@JsonProperty("resourceId") long resourceId,
                                          @JsonProperty("segmentIds") Set<Long> segmentIds,
                                          @JsonProperty("location") MdsLocation location,
                                          @JsonProperty("storageType") MdsStorageType storageType,
                                          @JsonProperty("numerator") long numerator,
                                          @JsonProperty("denominator") long denominator,
                                          @JsonProperty("abcServiceId") Long abcServiceId) {
        this.resourceId = resourceId;
        this.segmentIds = segmentIds;
        this.location = location;
        this.storageType = storageType;
        this.numerator = numerator;
        this.denominator = denominator;
        this.abcServiceId = abcServiceId;
    }

    @ApiModelProperty("Term resource id")
    public long getResourceId() {
        return resourceId;
    }

    @ApiModelProperty("Term resource segment id set")
    public Set<Long> getSegmentIds() {
        return segmentIds;
    }

    @ApiModelProperty("Term location")
    public MdsLocation getLocation() {
        return location;
    }

    @ApiModelProperty("Term storage type")
    public MdsStorageType getStorageType() {
        return storageType;
    }

    @ApiModelProperty("Term factor numerator")
    public long getNumerator() {
        return numerator;
    }

    @ApiModelProperty("Term factor denominator")
    public long getDenominator() {
        return denominator;
    }

    @ApiModelProperty("Term ABC service id")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Optional<Long> getAbcServiceId() {
        return Optional.ofNullable(abcServiceId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BaseResourceMdsRelationTermDto that = (BaseResourceMdsRelationTermDto) o;
        return resourceId == that.resourceId &&
                numerator == that.numerator &&
                denominator == that.denominator &&
                Objects.equals(segmentIds, that.segmentIds) &&
                location == that.location &&
                storageType == that.storageType &&
                Objects.equals(abcServiceId, that.abcServiceId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceId, segmentIds, location, storageType, numerator, denominator, abcServiceId);
    }

    @Override
    public String toString() {
        return "BaseResourceMdsRelationTermDto{" +
                "resourceId=" + resourceId +
                ", segmentIds=" + segmentIds +
                ", location=" + location +
                ", storageType=" + storageType +
                ", numerator=" + numerator +
                ", denominator=" + denominator +
                ", abcServiceId=" + abcServiceId +
                '}';
    }

}
