package ru.yandex.qe.dispenser.ws.base_resources.model;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
@ApiModel("A relation for a base resource mapping")
public final class BaseResourceRelationDto {

    private final BaseResourceLinearRelationDto linear;
    private final BaseResourceMdsRelationDto mds;

    @JsonCreator
    public BaseResourceRelationDto(@JsonProperty("linear") BaseResourceLinearRelationDto linear,
                                   @JsonProperty("mds") BaseResourceMdsRelationDto mds) {
        this.linear = linear;
        this.mds = mds;
    }

    @ApiModelProperty("Linear relation")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Optional<BaseResourceLinearRelationDto> getLinear() {
        return Optional.ofNullable(linear);
    }

    @ApiModelProperty("MDS relation")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Optional<BaseResourceMdsRelationDto> getMds() {
        return Optional.ofNullable(mds);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BaseResourceRelationDto that = (BaseResourceRelationDto) o;
        return Objects.equals(linear, that.linear) &&
                Objects.equals(mds, that.mds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(linear, mds);
    }

    @Override
    public String toString() {
        return "BaseResourceRelationDto{" +
                "linear=" + linear +
                ", mds=" + mds +
                '}';
    }

}
